package de.fau.spicsim.dev

import avrora.sim.Simulator
import avrora.sim.State
import avrora.sim.mcu.SPI
import avrora.sim.mcu.SPIDevice
import cck.util.Arithmetic
import de.fau.spicsim.interfaces.DevObserver
import de.fau.spicsim.interfaces.SevenSegInterface
import de.fau.spicsim.interfaces.SpicSimDev
import avrora.sim.clock.MainClock
import de.fau.spicsim.interfaces.SpicSimDevUpdater

class SevenSegDev(ssdu: SpicSimDevUpdater) extends SpicSimDev(ssdu) with DevObservable with DevObserver with SPIDevice {
	//Config

	private def bs(reg: Byte, bit: Int) = Arithmetic.getBit(reg, bit)

	val segMap = List(
		0, // 0
		1, // 1
		2, // 2
		3, // 3
		4, // 4
		5, // 5
		6  // 6
	)

	val segc = List.fill(2)(List.fill(7)(new PwmMon(this)))

	def notify(subject: Any, data: Any) {
		updateAndNotify(data)
	}
	import scala.language.reflectiveCalls
	val sMon = new Simulator.Watch.Empty {

		def getport(port: String) = interp.getRegisterByte(mcu.getProperties.getIORegAddr(port))
		def regWatch(port: String) = sim.insertWatch(this, mcu.getProperties.getIORegAddr(port))

		override def fireAfterWrite(state: State, data_addr: Int, value: Byte) {
			val portb = getport("PORTB")
			val ddrb = getport("DDRB")

			if (bs(ddrb, 2) && ! bs(portb, 2)) {
				val segId = (latchedData >> 7) & 1

				setSegOff(1 - segId)

				for (seg <- 0 to 6) {
					setSeg(segId, segMap(seg), ! bs(latchedData, seg))
				}

			} else {
				setSegOff(0)
				setSegOff(1)
				latchedData = data
			}
		}
	}

	override def registerSim(sim: Simulator) {
		super.registerSim(sim)
		sMon.regWatch("PORTB")
		sMon.regWatch("DDRB")
	}

	def setSeg(sSegId: Int, seg: Int, on: Boolean) {
		segc(sSegId)(seg).setLevel(on)
	}

	def setSegOff(sSegId: Int) {
		segc(sSegId).foreach(_.setLevel(false))
	}

	var data: Byte = 0
	var latchedData: Byte = 0

	def exchange(frame: SPI.Frame): SPI.Frame = {
		var tmp: Byte = frame.data
		val frame2 = SPI.newFrame(data)
		data = tmp

		frame2
	}

	def connect(d: SPIDevice) {
		/* FIXME */
	}
}
