package de.fau.spicsim.gui

class Skin(val name: String,
           val window: Class[_ <: MainWindow])

class SkinManager {

    private val SKIN_BOARD  = new Skin("board", classOf[MainWindowBoard])
    private val SKIN_COFFEE = new Skin("coffee", classOf[MainWindowCoffee])

    private val availableSkins = Array[Skin](SKIN_BOARD, SKIN_COFFEE)

    private val defaultSkin = SKIN_BOARD

    def getAvailableSkins = {
        val availableSkinNames = availableSkins.map(x => x.name)
        joinStrings(", ", availableSkinNames)
    }

    def getDefaultSkin = {
        defaultSkin.name
    }

    def checkSkin(skinName: String) = {
        val availableSkinNames = availableSkins.map(x => x.name)
        skinName != null && availableSkinNames.contains(skinName)
    }

    def windowForSkin(skinName: String): MainWindow = {
        var window = defaultSkin.window

        if(skinName != null){
            for(skin <- availableSkins){
                if(skin.name.equals(skinName)){
                    window = skin.window
                }
            }
        }

        return window.getConstructor().newInstance().asInstanceOf[MainWindow]
    }

    private def joinStrings(delim: String, strings: Array[String]) = {
        if(strings.length > 0){
            val stringBuilder = new StringBuilder

            for (str <- strings) {
                stringBuilder.append(str)
                stringBuilder.append(delim)
            }

            stringBuilder.delete(stringBuilder.length - delim.length, stringBuilder.length)

            stringBuilder.toString;
        }else{
            "";
        }
    }

}
