#include <cyg/hal/hal_arch.h>
#include <cyg/kernel/kapi.h>
#include <stdio.h>

#include "ezs_sb16.h"

#include "common.h"

SB16 sb16;

void cyg_user_start(void)
{
	printf("initializing SB16\n");
	ezs_sb16_init(&sb16,
			0x220 /* io address */,
			5 /* interrupt */,
			1 /* 8 bit DMA */,
			5 /* 16 bit DMA */);

	printf("initializing HPET\n");
	ezs_counter_init();

	// Initialize Tracer
	printf("initializing tracer\n");
	int res = ezs_trace_init();
	printf("tracer resolution: %d\r\n" , res);

	cyg_clock_to_counter(cyg_real_time_clock(), &s_real_time_counter);

	init_tasks();
}
