#include <pkgconf/system.h>
#include <cyg/io/io.h>
#include <cyg/error/codes.h>
#include <stdint.h>
#include <stdio.h>
#include <ezs_counter.h>
extern "C" {
#include <ezs_sb16.h>
}

static cyg_io_handle_t handle;
const char serialdevice[] = "/dev/ser1";
#define STRLEN 64
static cyg_uint32 len = STRLEN;
static char tracestring[STRLEN];

extern "C" SB16 sb16;

extern "C" int ezs_trace_init(){
	return cyg_io_lookup(serialdevice, &handle);
}

//! No Time triggered kernel -> normal event triggered ecos:
#ifndef SMLPKG_TTKERNEL
#include <cyg/kernel/kernel.hxx> 	// C Kernel-API
extern "C" {
#include <cyg/kernel/kapi.h> 	// C Kernel-API
}
class Cyg_Thread;

extern "C" void ezs_instrument(Cyg_Thread* current, Cyg_Thread* next) {
//	return;
	int prio = next->get_priority();
	if(prio > 32) prio = 32;
	ezs_sb16_play_dac1(&sb16, prio);
}

#else
#include <sml/ttkernel/task.hxx>
extern "C" void ezs_instrument(TT_Task* current, TT_Task* next){
	ezs_sb16_play_dac1(&sb16, next->get_id());
}
#endif

