/*
 * An extremely complex driver implementation
 * for the Qemu-emulated counter.
 *
 * Author: Martin Hoffmann
 *
 */

#include "ezs_counter.h"

#define MINI_EZS_COUNTER_ADDR 0x60002000
/// Memory-Mapped counter register
unsigned int volatile const * const mini_counter = (const unsigned int*) MINI_EZS_COUNTER_ADDR;

/**
 * Get current counter value
 * @return current counter value
 */
cyg_uint32 ezs_counter_get(){
  return *mini_counter;
}

/**
 * Get counter resolution in microseconds.
 * @return counter resolution in microseconds.
 */
cyg_uint32 ezs_counter_resolution_us(){
  return 100;
}
