#include <cyg/hal/hal_arch.h>
#include <cyg/kernel/kapi.h>
#include <stdio.h>
#include <math.h>
#include <assert.h>

#include "ezs_counter.h"
#include "ezs_fb.h"
#include "ezs_fft.h"
#include "ezs_interpolation.h"
#include "ezs_keycodes.h"
#include "ezs_plot.h"
#include "ezs_plot_pds.h"
#include "ezs_sb16.h"
#include "ezs_stopwatch.h"

#define FFT_LENGTH 128
#define TIME_DOMAIN_LENGTH (2 * FFT_LENGTH)
static cyg_uint32 s_time_domain[TIME_DOMAIN_LENGTH];
static float s_frequency_domain[FFT_LENGTH];
static unsigned int s_position = 0;

#define STACKSIZE    (CYGNUM_HAL_STACK_SIZE_MINIMUM+4096)

enum Command
{
	Invalid     = 0,

	DisplayTime = (1 << 1),
	DisplayPDS  = (1 << 2),

	TriggerOn   = (1 << 3),
	TriggerOff  = (1 << 4),

	TLevelRise  = (1 << 5),
	TLevelFall  = (1 << 6),
};

// ====================================
// TODO: Definitionen geeignet anpassen
// ====================================
#define SAMPLING_TASK_PRIORITY 0
#define PROCRASTINATION_TASK_PRIORITY 0
#define DISPLAY_TASK_PRIORITY 0
#define ANALYSIS_TASK_PRIORITY 0

#define SAMPLING_TASK_PERIOD 0
#define PROCRASTINATION_TASK_PERIOD 0
#define DISPLAY_TASK_PERIOD 0
#define ANALYSIS_TASK_PERIOD 0

#define SAMPLING_TASK_PHASE 0
#define PROCRASTINATION_TASK_PHASE 0
#define ANALYSIS_TASK_PHASE 0
#define DISPLAY_TASK_PHASE 0
// ====================================


// ==================================
// TODO: Definition geeignet anpassen
// ==================================
#define KEYBOARD_BUFFER_LENGTH 0

static char s_key_buffer[KEYBOARD_BUFFER_LENGTH];
static unsigned int s_key_position;
static char s_char;
static cyg_uint8 s_scancode;

// KeyThread
static cyg_uint8 keystack[STACKSIZE];
static cyg_handle_t keyhandle;
static cyg_thread   keydata;

// Interrupt
static cyg_interrupt key_intr;
static cyg_handle_t key_intr_handle;

#define KBDATAPORT 0x0060   // data I/O port
#define KBSTATPORT 0x0064   // status port (read)

SB16 sb16;

static cyg_uint32 keyb_isr_handler(cyg_vector_t vector, cyg_addrword_t data)
{
	cyg_interrupt_acknowledge(vector);
	// Read Keyboard status
	cyg_uint8 kbstat, code = 0;
	HAL_READ_UINT8( KBSTATPORT, kbstat ); 
	// If Data available, read them -> implicitly acknowledges interrupt on hardware side!
	if( (kbstat & 0x01) != 0 ){
		HAL_READ_UINT8( KBDATAPORT, code );
		// ====================
		// TODO: Code ergaenzen
		// ====================
		s_scancode = code;

		// Only resume thread, if there is a new keycode.
		return CYG_ISR_CALL_DSR | CYG_ISR_HANDLED;
	}
	return CYG_ISR_HANDLED;
}

static void keyb_dsr_handler(cyg_vector_t vector, cyg_ucount32 count, cyg_addrword_t data)
{
	// ====================
	// TODO: Code ergaenzen
	// ====================
	unsigned char keycode;
	if (!(s_scancode & 0x80)) {
		keycode = get_char_from_keycode(s_scancode);
		printf("%c\n", keycode);
	}
}

static void keythread(cyg_addrword_t arg){
	while(1) {
		// ====================
		// TODO: Code ergaenzen
		// ====================

		cyg_thread_suspend(cyg_thread_self());
	}
}

static int packet_receive(char c)
{
	assert(s_key_position < KEYBOARD_BUFFER_LENGTH);

	// ====================
	// TODO: Code ergaenzen
	// ====================
	return 0;
}

enum Command decode_command(void)
{

	enum Command ret = Invalid;

	// ====================
	// TODO: Code ergaenzen
	// ====================

	return ret;
}

// T1
static cyg_uint8     sampling_task_stack[STACKSIZE];
static cyg_handle_t  sampling_task_handle;
static cyg_thread    sampling_task_thread;
static void sampling_task_entry(cyg_addrword_t data)
{
	while (1) {
		// ====================
		// TODO: Code ergaenzen
		// ====================

		cyg_thread_suspend(cyg_thread_self());
	}
}

// T2
static cyg_uint8     procrastination_task_stack[STACKSIZE];
static cyg_handle_t  procrastination_task_handle;
static cyg_thread    procrastination_task_thread;
static void procrastination_task_entry(cyg_addrword_t data)
{
	while (1) {
		// ====================
		// TODO: Code ergaenzen
		// ====================

		cyg_thread_suspend(cyg_thread_self());
	}
}

// T3
static cyg_uint8     analysis_task_stack[STACKSIZE];
static cyg_handle_t  analysis_task_handle;
static cyg_thread    analysis_task_thread;
static void analysis_task_entry(cyg_addrword_t data)
{
	while (1) {
		ezs_easy_pds(s_time_domain, s_frequency_domain, TIME_DOMAIN_LENGTH);

		cyg_thread_suspend(cyg_thread_self());
	}
}


// T4
static cyg_uint8     display_task_stack[STACKSIZE];
static cyg_handle_t  display_task_handle;
static cyg_thread    display_task_thread;
static void display_task_entry(cyg_addrword_t data)
{
	while (1) {
		// ====================
		// TODO: Code ergaenzen
		// ====================

		cyg_thread_suspend(cyg_thread_self());
	}
}

static void sampling_task_alarmfn(cyg_handle_t alarmH, cyg_addrword_t data)
{
	cyg_thread_resume(sampling_task_handle);
}

static void procrastination_task_alarmfn(cyg_handle_t alarmH, cyg_addrword_t data)
{
	cyg_thread_resume(procrastination_task_handle);
}

static void analysis_task_alarmfn(cyg_handle_t alarmH, cyg_addrword_t data)
{
	cyg_thread_resume(analysis_task_handle);
}

static void display_task_alarmfn(cyg_handle_t alarmH, cyg_addrword_t data)
{
	cyg_thread_resume(display_task_handle);
}

static cyg_handle_t sampling_task_alarm_handle;
static cyg_handle_t procrastination_task_alarm_handle;
static cyg_handle_t analysis_task_alarm_handle;
static cyg_handle_t display_task_alarm_handle;

static cyg_alarm sampling_task_alarm;
static cyg_alarm procrastination_task_alarm;
static cyg_alarm analysis_task_alarm;
static cyg_alarm display_task_alarm;


static cyg_handle_t real_time_counter;

static cyg_addrword_t data_dummy = 0;

void cyg_user_start(void)
{
	// Initialize framebuffer in graphic mode
	ezs_fb_init();
	// Initialize soundblaster
	ezs_sb16_init(&sb16,
			0x220 /* io address */,
			5 /* interrupt */,
			1 /* 8 bit DMA */,
			5 /* 16 bit DMA */);

	// Initialize HPET counter
	ezs_counter_init();

	// Initialize Tracer
	int res = ezs_trace_init();
	printf("init res: %d\r\n" , res);

	// Create keyboard interrupt, attach to handler table and umask
	cyg_interrupt_create(CYGNUM_HAL_INTERRUPT_KEYBOARD, 1, (cyg_addrword_t) &keyhandle, keyb_isr_handler, keyb_dsr_handler, &key_intr_handle, &key_intr);
	cyg_interrupt_attach(key_intr_handle);
	cyg_interrupt_unmask(CYGNUM_HAL_INTERRUPT_KEYBOARD);

	cyg_thread_create(SAMPLING_TASK_PRIORITY, &sampling_task_entry, 0, "sampling task",
			sampling_task_stack, STACKSIZE,
			&sampling_task_handle, &sampling_task_thread);
	cyg_thread_create(PROCRASTINATION_TASK_PRIORITY, &procrastination_task_entry, 0, "procrastination task",
			procrastination_task_stack, STACKSIZE,
			&procrastination_task_handle, &procrastination_task_thread);
	cyg_thread_create(ANALYSIS_TASK_PRIORITY, &analysis_task_entry, 0, "analysis task",
			analysis_task_stack, STACKSIZE,
			&analysis_task_handle, &analysis_task_thread);
	cyg_thread_create(DISPLAY_TASK_PRIORITY, &display_task_entry, 0, "display task",
			display_task_stack, STACKSIZE,
			&display_task_handle, &display_task_thread);

	// Create keyboard thread
	cyg_thread_create(5, &keythread, 0, "Keyboard", keystack, STACKSIZE,
			&keyhandle, &keydata);



	cyg_clock_to_counter(cyg_real_time_clock(), &real_time_counter);

	cyg_tick_count_t offset = cyg_counter_current_value(real_time_counter);

	cyg_alarm_create(real_time_counter, sampling_task_alarmfn, data_dummy, &sampling_task_alarm_handle, &sampling_task_alarm);
	cyg_alarm_initialize(sampling_task_alarm_handle, offset + SAMPLING_TASK_PHASE, SAMPLING_TASK_PERIOD);
	cyg_alarm_create(real_time_counter, procrastination_task_alarmfn, data_dummy, &procrastination_task_alarm_handle, &procrastination_task_alarm);
	cyg_alarm_initialize(procrastination_task_alarm_handle, offset + PROCRASTINATION_TASK_PHASE, PROCRASTINATION_TASK_PERIOD);
	cyg_alarm_create(real_time_counter, analysis_task_alarmfn, data_dummy, &analysis_task_alarm_handle, &analysis_task_alarm);
	cyg_alarm_initialize(analysis_task_alarm_handle, offset + ANALYSIS_TASK_PHASE, ANALYSIS_TASK_PERIOD);
	cyg_alarm_create(real_time_counter, display_task_alarmfn, data_dummy, &display_task_alarm_handle, &display_task_alarm);
	cyg_alarm_initialize(display_task_alarm_handle, offset + DISPLAY_TASK_PHASE, DISPLAY_TASK_PERIOD);
}
