/**
 *
 * \file ezs_uart.h
 * \ingroup hw
 * \brief EZS UART Hardware Driver API 
 *
 */

#ifndef _EZS_UART_H_
#define _EZS_UART_H_

#ifndef SMLPKG_TTKERNEL
#include <cyg/kernel/kapi.h>
void ezs_uart_register_irq_handler(cyg_ISR_t isr_func, cyg_DSR_t dsr_func, cyg_addrword_t data);
#endif

void ezs_uart_init(void);
void ezs_uart_enable_int(void);
void ezs_uart_disable_int(void);
void ezs_uart_acknowledge_int(void);
cyg_uint8 ezs_uart_getc(void);
void ezs_uart_putc(cyg_uint8 ch);

#endif


