#ifndef EZS_EQUALIZER_H_INCLUDED
#define EZS_EQUALIZER_H_INCLUDED

#include <stdint.h>

#define EZS_EQUALIZER_BANDS 16

typedef struct EZS_Equalizer {
  uint8_t band[EZS_EQUALIZER_BANDS];
} EZS_Equalizer;

void ezs_equalizer_set_band(EZS_Equalizer *eq, size_t band, uint8_t value);
void ezs_equalizer_init(EZS_Equalizer *eq);
int16_t ezs_equalizer_filter(EZS_Equalizer *eq, int16_t value);
void ezs_equalizer_destroy(EZS_Equalizer *eq);



#endif // EZS_EQUALIZER_H_INCLUDED
