#ifndef __COUNTER_H__
#define __COUNTER_H__
/**
 * @file counter.h 
 * 
 * \ingroup hw
 * @brief The libEZS counter API
 * @author Martin Hoffmann
 */

#include <cyg/infra/cyg_type.h>

void ezs_counter_init(void);
/**
 * \brief Read the current counter value from hardware counter.
 * @return counter value (time resolution \see ezs_counter_resolution_us)
 */
#ifdef __cplusplus
extern "C"
#endif
cyg_uint64 ezs_counter_get(void);
/**
 * \brief Returns the current time resolution of the hardware counter.
 * @return tick resolution in microseconds
 */
cyg_uint64 ezs_counter_resolution_us(void);
#endif 
