#define EZS_HPET_ADDR  0xFED00000

#include "ezs_counter.h"
#include <stdio.h>
#include <stdint.h>

typedef struct hpetReg {
  uint64_t  GCAP_ID;    /* General capabilities */
  uint64_t  rsv1;
  uint64_t  GEN_CONF;   /* General configuration */
  uint64_t  rsv2;
  uint64_t  GINTR_STA;    /* General Interrupt status */
  uint64_t  rsv3[25];
  uint64_t  MAIN_CNT;   /* Main counter */
  uint64_t  rsv4;
  uint64_t  TIM0_CONF;    /* Timer 0 config and cap */
#define     TIM_CONF 0
#define     Tn_INT_ENB_CNF 4
  uint64_t  TIM0_COMP;    /* Timer 0 comparator */
#define     TIM_COMP 8
  uint64_t  rsv5[2];
  uint64_t  TIM1_CONF;    /* Timer 1 config and cap */
  uint64_t  TIM1_COMP;    /* Timer 1 comparator */
  uint64_t  rsv6[2];
  uint64_t  TIM2_CONF;    /* Timer 2 config and cap */
  uint64_t  TIM2_COMP;    /* Timer 2 comparator */
  uint64_t  rsv7[2];
} hpetReg;
typedef struct  hpetReg hpetReg_t;

volatile hpetReg_t *hpet = (volatile hpetReg_t *) EZS_HPET_ADDR;

static uint64_t hpet_divisor = 0;

uint32_t ezs_hpet_period_fs(void)
{
  return hpet->GCAP_ID >> 32;
}

void ezs_hpet_init(void)
{
  uint8_t rev_id = hpet->GCAP_ID & 0xFF;
  uint8_t num_timers = (hpet->GCAP_ID >> 8) & 0x1F;
  uint8_t counter_size = (hpet->GCAP_ID >> 13) & 0x1;
  uint16_t vendor_id = (hpet->GCAP_ID >> 16) & 0xFF;
  uint32_t period = ezs_hpet_period_fs();
  hpet_divisor = 1000000000ULL / ezs_hpet_period_fs(); // 10e9 fs == 1 us
  printf("hpet_divisor = %d, rev_id = %d, num_timers = %d, counter_size = %d, vendor_id = %d, period = %d\n",
      hpet_divisor, rev_id, num_timers, counter_size, vendor_id, period);

  /* enable HPET */
  hpet->GEN_CONF = 0x1;
}

uint64_t ezs_hpet_read(void)
{
  return hpet->MAIN_CNT;
}

uint64_t ezs_hpet_resolution_us(void)
{
  return 1;
}

uint64_t ezs_hpet_read_us(void)
{
  return ezs_hpet_read() / hpet_divisor;
}

void ezs_counter_init(void)
{
  ezs_hpet_init();
}


cyg_uint64 ezs_counter_get(void)
{
  return ezs_hpet_read_us();
}

cyg_uint64 ezs_counter_resolution_us(void)
{
  return ezs_hpet_resolution_us();
}
