
#include <cyg/kernel/kapi.h>
#include <stdio.h>

#include "ezs_fb.h"
#include "ezs_sb16.h"
#include "ezs_counter.h"
#include "ezs_trace.h"
#include <cyg/io/framebuf.h>
#include <cyg/io/framebufs/i386_fb.h>


#define STACKSIZE CYGNUM_HAL_STACK_SIZE_MINIMUM+1024
// Thread 1
static cyg_uint8 my_stack[STACKSIZE];
static cyg_handle_t threadhndl1;
static cyg_thread   threaddata;
static cyg_alarm 	alarm1;
static cyg_handle_t alarmhnd1;
// KeyThread
static cyg_uint8 keystack[STACKSIZE];
static cyg_handle_t keyhandle;
static cyg_thread   keydata;

// Interrupt
static cyg_interrupt intr;
static cyg_handle_t handle;

// global keycode variable
static cyg_uint8 g_keycode;

SB16 sb16;
#define KBDATAPORT 0x0060   // data I/O port
#define KBSTATPORT 0x0064   // status port (read)

void
keyb_dsr_handler(cyg_vector_t vector, cyg_ucount32 count, cyg_addrword_t data)
{
	 // Deferred interrupt service routine, synchronous to kernel
	cyg_thread_resume(*((cyg_handle_t*)data));
}

cyg_uint32
keyb_isr_handler(cyg_vector_t vector, cyg_addrword_t data)
{
	cyg_interrupt_acknowledge(vector);
	// Read Keyboard status
	cyg_uint8 kbstat, code = 0;
	HAL_READ_UINT8( KBSTATPORT, kbstat ); 
	// If Data available, read them -> implicitly acknowledges interrupt on hardware side!
	if( (kbstat & 0x01) != 0 ){
		HAL_READ_UINT8( KBDATAPORT, code );
		g_keycode = code;
		// Only resume thread, if there is a new keycode.
		return CYG_ISR_CALL_DSR | CYG_ISR_HANDLED;
	}
	return CYG_ISR_HANDLED;
}


void alarm_handler(cyg_handle_t alarm, cyg_addrword_t data){
		cyg_thread_resume(*((cyg_handle_t*) data));
}


// A little test thread.
void thread(cyg_addrword_t arg){
	uint8_t counter = 0;
	while(1) {
		//printf("Hallo!\r\n");
		ezs_sb16_play_sample(&sb16, counter++);
		cyg_thread_suspend(cyg_thread_self());
	}
}

// A little test thread.
void keythread(cyg_addrword_t arg){
	while(1) {
		printf("Keycode: %d\r\n", g_keycode);
		cyg_thread_suspend(cyg_thread_self());
	}
}

void cyg_user_start(void){
	// Initialize framebuffer in graphic mode
	ezs_fb_init();
	// Initialize soundblaster
	ezs_sb16_init(&sb16,
			0x220 /* io address */,
			5 /* interrupt */,
			1 /* 8 bit DMA */,
			5 /* 16 bit DMA */);

	// Initialize HPET counter
	ezs_counter_init();

	// Initialize Tracer
	int res = ezs_trace_init();
	printf("init res: %d\r\n" , res);

	// Create keyboard interrupt, attach to handler table and umask
	cyg_interrupt_create(CYGNUM_HAL_INTERRUPT_KEYBOARD, 1, (cyg_addrword_t) &keyhandle, keyb_isr_handler, keyb_dsr_handler, &handle, &intr) ;
	cyg_interrupt_attach(handle);
	cyg_interrupt_unmask(CYGNUM_HAL_INTERRUPT_KEYBOARD);

	// Create test thread
	cyg_thread_create(11, &thread, 0, "Abtastung1", my_stack, STACKSIZE,
			&threadhndl1, &threaddata);

	// Create keyboard thread
	cyg_thread_create(5, &keythread, 0, "Keyboard", keystack, STACKSIZE,
			&keyhandle, &keydata);


	cyg_handle_t counter;
	cyg_clock_to_counter(cyg_real_time_clock(), &counter);
	cyg_alarm_create(counter, alarm_handler, (cyg_addrword_t) &threadhndl1 , &alarmhnd1, &alarm1);
	cyg_alarm_initialize(alarmhnd1, 0, 10);
	cyg_alarm_enable(alarmhnd1);

}

