#include <cyg/hal/hal_arch.h>
#include <cyg/kernel/kapi.h>
#include <stdio.h>

#include "ezs_fb.h"
#include "ezs_sb16.h"
#include "ezs_counter.h"

#include <cyg/io/framebuf.h>
#include <cyg/io/framebufs/i386_fb.h>


#define STACKSIZE CYGNUM_HAL_STACK_SIZE_MINIMUM+1024
static cyg_uint8 my_stack[STACKSIZE];
static cyg_handle_t handle;
static cyg_thread   threaddata;

SB16 sb16;
#define KBDATAPORT 0x0060   // data I/O port
#define KBSTATPORT 0x0064   // status port (read)

cyg_uint32 keyb_isr_handler(cyg_vector_t vector, cyg_addrword_t data)
{
  cyg_interrupt_acknowledge(vector);
  // Read Keyboard status
  cyg_uint8 kbstat, code = 0;
  HAL_READ_UINT8( KBSTATPORT, kbstat ); 
  // If Data available, read them -> implicitly acknowledges interrupt!
  // TODO Buffer Keycode and print it in Keyboard-Thread
  if( (kbstat & 0x01) != 0 ){
    HAL_READ_UINT8( KBDATAPORT, code );
  }
  // This printf is just for visualisation. Comment it out for further measurements!
  printf("-> int %d, stat: %d, code: %d\r\n", vector, kbstat, code);
  return CYG_ISR_HANDLED;
}

void keyb_dsr_handler(cyg_vector_t vector, cyg_ucount32 count, cyg_addrword_t data)
{
  // Deferred interrupt service routine, synchronous to kernel
}

static cyg_interrupt intr;
static cyg_handle_t handle;

// A little test thread.
void thread(cyg_addrword_t arg){
  ezs_fb_print_string_cur("Hallo\nZeit!", 0, 150, FB_WHITE);

  while(1) {
    cyg_thread_delay(1000); // Time base is set to 1 ms in this ecos configuration!
  }
}

void cyg_user_start(void){
  // Initialize framebuffer in graphic mode
  ezs_fb_init();
  // Initialize soundblaster
  ezs_sb16_init(&sb16,
      0x220 /* io address */,
      5 /* interrupt */,
      1 /* 8 bit DMA */,
      5 /* 16 bit DMA */);
  // Connect the amplifier
  // ezs_sb16_sound_on(&sb16);

  // Initialize HPET counter
  ezs_hpet_init();

  // Create keyboard interrupt, attach to handler table and umask
  cyg_interrupt_create(CYGNUM_HAL_INTERRUPT_KEYBOARD, 1, 0, keyb_isr_handler, keyb_dsr_handler, &handle, &intr) ;
  cyg_interrupt_attach(handle);
  cyg_interrupt_unmask(CYGNUM_HAL_INTERRUPT_KEYBOARD);

  // Create test thread
  cyg_thread_create(11, &thread, 0, "thread1", my_stack, STACKSIZE,
      &handle, &threaddata);

  // and set thread ready to run
  cyg_thread_resume(handle);
}

