#include <pkgconf/system.h>
#include <cyg/io/io.h>
#include <cyg/error/codes.h>
#include <stdint.h>
#include <stdio.h>


//! No Time triggered kernel -> normal event triggered ecos:
#ifndef SMLPKG_TTKERNEL
#include <cyg/kernel/kernel.hxx> 	// C Kernel-API
extern "C" {
#include <cyg/kernel/kapi.h> 	// C Kernel-API
#include "ezs_counter.h"
}
class Cyg_Thread;

static cyg_io_handle_t handle;
const char serialdevice[] = "/dev/ser1";

extern "C" int trace_init(){
	return cyg_io_lookup(serialdevice, &handle);
}

extern "C" void ezs_instrument(Cyg_Thread* current, Cyg_Thread* next) {
	return;
	int prio = next->get_priority();
	uint64_t timestamp = ezs_counter_get();
	printf("%u;%d\r\n", (uint32_t) timestamp, prio);
}

#else
#include <sml/ttkernel/task.hxx>
extern "C" void ezs_instrument(TT_Task* current, TT_Task* next){
	ezs_dac_set_n(next->get_id(), 1);
}
#endif

